<?php

add_filter( 'etm_register_advanced_settings', 'etm_register_hreflang_remove_locale', 1000 );
/**
 * Register advanced configuration option for removing duplicate hreflang tags.
 *
 * @param array $settings_array The array of settings to add.
 * @return array The updated array of settings.
 */
function etm_register_hreflang_remove_locale( $settings_array ) {
	$settings_array[] = array(
		'name'        => 'hreflang_remove_locale',
		'type'        => 'radio',
		'options'     => array( 'show_both', 'remove_country_locale', 'remove_region_independent_locale' ),
		'default'     => 'show_both',
		'labels'      => array( esc_html__( 'Show Both (recommended)', 'etranslation-multilingual' ), esc_html__( 'Remove Country Locale', 'etranslation-multilingual' ), esc_html__( 'Remove Region Independent Locale', 'etranslation-multilingual' ) ),
		'label'       => esc_html__( 'Remove duplicate hreflang', 'etranslation-multilingual' ),
		'description' => wp_kses(
			__( 'Choose which hreflang tags will appear on your website.<br/>We recommend showing both types of hreflang tags as indicated by <a href="https://developers.google.com/search/docs/advanced/crawling/localized-versions" title="Google Crawling" target="_blank">Google documentation</a>.<br/>Removing Country Locale when having multiple Country Locales of the same language (ex. English UK and English US) will result in showing one hreflang tag with a link to just one of the region locales for that language.', 'etranslation-multilingual' ),
			array(
				'br' => array(),
				'a'  => array(
					'href'   => array(),
					'title'  => array(),
					'target' => array(),
				),
			)
		),
	);
	return $settings_array;
}

add_filter( 'etm_add_country_hreflang_tags', 'etm_display_country_hreflang_tag' );
/**
 * Decide whether to display country-specific hreflang tags based on the user's choice.
 *
 * @param bool $display Whether to display the country-specific hreflang tags.
 * @return bool Whether to display the country-specific hreflang tags.
 */
function etm_display_country_hreflang_tag( $display ) {
	$option = get_option( 'etm_advanced_settings', true );
	if ( isset( $option['hreflang_remove_locale'] ) && $option['hreflang_remove_locale'] === 'remove_country_locale' ) {
		return false;
	}
	return $display;
}

add_filter( 'etm_add_region_independent_hreflang_tags', 'etm_display_region_independent_hreflang_tag' );
/**
 * Decide whether to display region-independent hreflang tags based on the user's choice.
 *
 * @param bool $display Whether to display the region-independent hreflang tags.
 * @return bool Whether to display the region-independent hreflang tags.
 */
function etm_display_region_independent_hreflang_tag( $display ) {

	$option = get_option( 'etm_advanced_settings', true );
	if ( isset( $option['hreflang_remove_locale'] ) && $option['hreflang_remove_locale'] === 'remove_region_independent_locale' ) {
		return false;
	}
	return $display;
}
