<div id="etm-main-settings" class="wrap">
	<form method="post" action="options.php">
		<?php settings_fields( 'etm_machine_translation_settings' ); ?>
		<h1 id="tab_title">
			<img id="tab_title__logo" alt="WEB-T logo" />
			<?php esc_html_e( 'WEB-T – eTranslation Multilingual Automated Translation', 'etranslation-multilingual' ); ?>
		</h1>
		<?php do_action( 'etm_settings_navigation_tabs' ); ?>

		<table id="etm-options" class="form-table etm-machine-translation-options">
			<tr>
				<th scope="row" id="etm-machine-translation-enabled-label"><?php esc_html_e( 'Enable Automated Translation', 'etranslation-multilingual' ); ?> </th>
				<td>
					<select id="etm-machine-translation-enabled" aria-labelledby="etm-machine-translation-enabled-label" name="etm_machine_translation_settings[machine-translation]" class="etm-select">
						<option value="yes" <?php selected( isset( $this->settings['etm_machine_translation_settings']['machine-translation'] ) && $this->settings['etm_machine_translation_settings']['machine-translation'] == 'yes', true ); ?>><?php esc_html_e( 'Yes', 'etranslation-multilingual' ); ?></option>
						<option value="no" <?php selected( isset( $this->settings['etm_machine_translation_settings']['machine-translation'] ) && $this->settings['etm_machine_translation_settings']['machine-translation'] == 'no', true ); ?>><?php esc_html_e( 'No', 'etranslation-multilingual' ); ?></option>
					</select>

					<p class="description">
						<?php esc_html_e( 'Enable or disable the automated translation of the site. To minimize translation costs, each untranslated string is automatedly translated only once, then stored in the database.', 'etranslation-multilingual' ); ?>
					</p>
				</td>
			</tr>

			<tr>
				<th scope="row" id="translation-engine-label"><?php esc_html_e( 'Translation Engine', 'etranslation-multilingual' ); ?> </th>
				<td aria-labelledby="translation-engine-label">
					<?php $translation_engines = apply_filters( 'etm_machine_translation_engines', array() ); ?>

					<?php foreach ( $translation_engines as $engine ) : ?>
						<label for="etm-translation-engine-<?php echo esc_attr( $engine['value'] ); ?>" style="margin-right:10px;">
							<input type="radio" class="etm-translation-engine etm-radio" id="etm-translation-engine-<?php echo esc_attr( $engine['value'] ); ?>" name="etm_machine_translation_settings[translation-engine]" value="<?php echo esc_attr( $engine['value'] ); ?>" <?php checked( $this->settings['etm_machine_translation_settings']['translation-engine'], $engine['value'] ); ?>>
							<?php echo esc_html( $engine['label'] ); ?>
						</label>
					<?php endforeach; ?>

					<p class="description">
						<?php esc_html_e( 'Choose which engine you want to use in order to automatedly translate your website.', 'etranslation-multilingual' ); ?>
					</p>
				</td>
			</tr>

			<?php do_action( 'etm_machine_translation_extra_settings_middle', $this->settings['etm_machine_translation_settings'] ); ?>

			<?php if ( ! empty( $machine_translator->credentials_set() ) ) : ?>
				<tr id="etm-test-api-key">
					<td></td>
					<td>
						<a href="<?php echo esc_url( admin_url( 'admin.php?page=etm_test_machine_api' ) ); ?>" class="button-secondary"><?php esc_html_e( 'Test API credentials', 'etranslation-multilingual' ); ?></a>
						<p class="description">
							<?php esc_html_e( 'Click here to check if the selected translation engine is configured correctly.', 'etranslation-multilingual' ); ?>
						</p>
					</td>
				</tr>
			<?php endif; ?>

			<tr style="border-bottom: 1px solid #ccc;"></tr>

			<tr>
				<th scope="row" id="block-crawlers-label"><?php esc_html_e( 'Block Crawlers', 'etranslation-multilingual' ); ?></th>
				<td aria-labelledby="block-crawlers-label">
					<label>
						<input type=checkbox name="etm_machine_translation_settings[block-crawlers]" value="yes" <?php isset( $this->settings['etm_machine_translation_settings']['block-crawlers'] ) ? checked( $this->settings['etm_machine_translation_settings']['block-crawlers'], 'yes' ) : checked( '', 'yes' ); ?>>
						<?php esc_html_e( 'Yes', 'etranslation-multilingual' ); ?>
					</label>
					<p class="description">
						<?php esc_html_e( 'Block crawlers from triggering automated translations on your website.', 'etranslation-multilingual' ); ?>
					</p>
				</td>
			</tr>

			<tr>
			<th scope="row" id="log-mt-queries-label"><?php esc_html_e( 'Log machine translation queries.', 'etranslation-multilingual' ); ?></th>
			<td aria-labelledby="log-mt-queries-label">
				<label>
					<input type=checkbox name="etm_machine_translation_settings[machine_translation_log]" value="yes" <?php isset( $this->settings['etm_machine_translation_settings']['machine_translation_log'] ) ? checked( $this->settings['etm_machine_translation_settings']['machine_translation_log'], 'yes' ) : checked( '', 'yes' ); ?>>
					<?php esc_html_e( 'Yes', 'etranslation-multilingual' ); ?>
				</label>
				<p class="description">
						<?php
						echo wp_kses(
							__( 'Only enable for testing purposes. Can impact performance.<br>All records are stored in the wp_etm_machine_translation_log database table. Use a plugin like <a href="https://wordpress.org/plugins/wp-data-access/" target="_blank">WP Data Access</a> to browse the logs or directly from your database manager (PHPMyAdmin, etc.)', 'etranslation-multilingual' ),
							array(
								'br' => array(),
								'a'  => array(
									'href'   => array(),
									'title'  => array(),
									'target' => array(),
								),
							)
						);
						?>
				</p>
			</td>
		</tr>

		<tr>
				<th scope="row" id="show-mt-notice-label"><?php esc_html_e( 'Show machine translation notice', 'etranslation-multilingual' ); ?></th>
				<td>
					<select aria-labelledby="show-mt-notice-label" id="show-mt-notice" name="etm_machine_translation_settings[show-mt-notice]" class="etm-select">
						<option value="yes" <?php selected( $this->settings['etm_machine_translation_settings']['show-mt-notice'], 'yes' ); ?>><?php esc_html_e( 'Yes', 'etranslation-multilingual' ); ?></option>
						<option value="no" <?php selected( $this->settings['etm_machine_translation_settings']['show-mt-notice'], 'no' ); ?>><?php esc_html_e( 'No', 'etranslation-multilingual' ); ?></option>
					</select>
					<p class="description">
						<?php esc_html_e( 'Select No if you do not want to show machine translation notice bar at the top of every translated page.', 'etranslation-multilingual' ); ?>
					</p>
				</td>
			</tr>

			<?php do_action( 'etm_machine_translation_extra_settings_bottom', $this->settings['etm_machine_translation_settings'] ); ?>
		</table>

		<p class="submit"><input type="submit" class="button-primary" value="<?php esc_attr_e( 'Save Changes', 'etranslation-multilingual' ); ?>" /></p>
	</form>
</div>
